/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.conndata.PassthruInfo;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityBean;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;
import java.util.List;

public class PassThruSystemsBean
extends PanelBean
implements OutboundConnectivityConstants {
    private static final String TRACE_MASKT = "XRCSPTBT";
    private static final String TRACE_MASKF = "XRCSPTBF";
    private static final String TRACE_MASKD = "XRCSPTBD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-PThrBean");
    private boolean callHomeServer;
    private List passThruSystems;
    private List callHomeServers;
    private boolean m_bAllowPassThru;
    private transient ItemDescriptor[][] m_idDiscoveredServersTable;
    private transient ColumnDescriptor[] m_cdDiscoveredServersTableStructure;
    private int[] m_iDiscoveredServersTableSelection;
    private transient ItemDescriptor[][] m_idPassThruSystemsTable;
    private transient ColumnDescriptor[] m_cdPassThruSystemsTableStructure;
    private int[] m_iPassThruSystemsTableSelection;

    public PassThruSystemsBean() {
        Trace.trace(TRACE_MASKT, "<> PassThruSystemsBean()");
    }

    public void setAllowPassThru(boolean b) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setAllowPassThru(" + b + ")");
        this.m_bAllowPassThru = b;
        this.updateUTMElements();
        Trace.trace(TRACE_MASKT, "<- setAllowPassThru()");
    }

    public boolean isAllowPassThru() {
        return this.m_bAllowPassThru;
    }

    public void setDiscoveredServersTableSelection(int[] selected) throws IllegalUserDataException {
        if (selected != null && selected.length > 0) {
            Trace.trace(TRACE_MASKT, "-> setDiscoveredServersTableSelection(" + selected[0] + ")");
        } else {
            Trace.trace(TRACE_MASKT, "-> setDiscoveredServersTableSelection(none)");
        }
        this.m_iDiscoveredServersTableSelection = selected;
        this.updateUTMElements();
        Trace.trace(TRACE_MASKT, "<- setDiscoveredServersTableSelection()");
    }

    public int[] getDiscoveredServersTableSelection() {
        return this.m_iDiscoveredServersTableSelection;
    }

    public void setDiscoveredServersTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idDiscoveredServersTable[index] = items;
    }

    public ItemDescriptor[] getDiscoveredServersTableRowAt(int index) {
        return this.m_idDiscoveredServersTable[index];
    }

    public int getDiscoveredServersTableRowCount() {
        return this.m_idDiscoveredServersTable.length;
    }

    public int getDiscoveredServersTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getDiscoveredServersTableRowStructure() {
        return this.m_cdDiscoveredServersTableStructure;
    }

    public void setPassThruSystemsTableSelection(int[] selected) throws IllegalUserDataException {
        if (selected != null && selected.length > 0) {
            Trace.trace(TRACE_MASKT, "-> setPassThruSystemsTableSelection(" + selected[0] + ")");
        } else {
            Trace.trace(TRACE_MASKT, "-> setPassThruSystemsTableSelection(none)");
        }
        this.m_iPassThruSystemsTableSelection = selected;
        this.updateUTMElements();
        Trace.trace(TRACE_MASKT, "<- setPassThruSystemsTableSelection()");
    }

    public int[] getPassThruSystemsTableSelection() {
        return this.m_iPassThruSystemsTableSelection;
    }

    public void setPassThruSystemsTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idPassThruSystemsTable[index] = items;
    }

    public ItemDescriptor[] getPassThruSystemsTableRowAt(int index) {
        return this.m_idPassThruSystemsTable[index];
    }

    public int getPassThruSystemsTableRowCount() {
        return this.m_idPassThruSystemsTable.length;
    }

    public int getPassThruSystemsTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getPassThruSystemsTableRowStructure() {
        return this.m_cdPassThruSystemsTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> verifyChanges()");
        Trace.trace(TRACE_MASKT, "<- verifyChanges()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> load()");
        this.m_idDiscoveredServersTable = new ItemDescriptor[0][0];
        this.m_cdDiscoveredServersTableStructure = new ColumnDescriptor[0];
        this.m_iDiscoveredServersTableSelection = new int[0];
        this.m_idPassThruSystemsTable = new ItemDescriptor[0][0];
        this.m_cdPassThruSystemsTableStructure = new ColumnDescriptor[0];
        this.m_iPassThruSystemsTableSelection = new int[0];
        Trace.trace(TRACE_MASKT, "<- load()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "-> save()");
        Trace.trace(TRACE_MASKT, "<- save()");
    }

    public void setCallHomeServer(boolean value) {
        Trace.trace(TRACE_MASKT, "<> setCallHomeServer(" + value + ")");
        this.callHomeServer = value;
    }

    public List getPassThruSystems() {
        return this.passThruSystems;
    }

    public void setPassThruSystems(List systems) {
        Trace.trace(TRACE_MASKT, "<> setPassThruSystems(" + systems.size() + ")");
        this.passThruSystems = systems;
    }

    public void setCallHomeServers(List servers) {
        Trace.trace(TRACE_MASKT, "<> setCallHomeServers(" + servers.size() + ")");
        this.callHomeServers = servers;
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction(" + event + ")");
        try {
            String element = event.getElementName();
            if (element.endsWith("AddButton")) {
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setSource("PassThruSystemsBean");
                request.setData("Source", "PassThruSystemsPanel");
                request.setData("Command", "OpenAddPanel");
                this.postTaskletRequest(request);
            } else if (element.endsWith("EditButton")) {
                int[] selections = this.getPassThruSystemsTableSelection();
                if (selections.length >= 1) {
                    int selected = selections[0];
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource("PassThruSystemsBean");
                    request.setData("Source", "PassThruSystemsPanel");
                    request.setData("Command", "OpenEditPanel");
                    request.setData("PassThruInfo", this.passThruSystems.get(selected));
                    this.postTaskletRequest(request);
                }
            } else if (element.endsWith("RemoveButton")) {
                int[] selections = this.getPassThruSystemsTableSelection();
                if (selections.length >= 1) {
                    int selected = selections[0];
                    this.passThruSystems.remove(selected);
                    this.updateDataBeanInfo(false);
                    if (this.passThruSystems.size() >= 1) {
                        selections[0] = selected > 0 ? selected - 1 : 0;
                    } else {
                        selections = new int[]{};
                    }
                    this.setPassThruSystemsTableSelection(selections);
                }
            } else if (element.endsWith("TestButton")) {
                int[] selections = this.getPassThruSystemsTableSelection();
                if (selections.length >= 1) {
                    int selected = selections[0];
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource("PassThruSystemsBean");
                    request.setData("Source", "PassThruSystemsPanel");
                    request.setData("Command", "OpenTestPanel");
                    request.setData("PassThruInfo", this.passThruSystems.get(selected));
                    this.postTaskletRequest(request);
                }
            } else if (element.endsWith("UpButton")) {
                int selected;
                int[] selections = this.getPassThruSystemsTableSelection();
                if (selections.length >= 1 && (selected = selections[0]) > 0) {
                    PassthruInfo tempInfo = (PassthruInfo)this.passThruSystems.get(selected - 1);
                    this.passThruSystems.set(selected - 1, this.passThruSystems.get(selected));
                    this.passThruSystems.set(selected, tempInfo);
                    this.updateDataBeanInfo(false);
                    selections[0] = selected - 1;
                    this.setPassThruSystemsTableSelection(selections);
                }
            } else if (element.endsWith("DownButton")) {
                int selected;
                int[] selections = this.getPassThruSystemsTableSelection();
                if (selections.length >= 1 && (selected = selections[0]) < this.passThruSystems.size() - 1) {
                    PassthruInfo tempInfo = (PassthruInfo)this.passThruSystems.get(selected + 1);
                    this.passThruSystems.set(selected + 1, this.passThruSystems.get(selected));
                    this.passThruSystems.set(selected, tempInfo);
                    this.updateDataBeanInfo(false);
                    selections[0] = selected + 1;
                    this.setPassThruSystemsTableSelection(selections);
                }
            } else {
                Trace.trace(TRACE_MASKF, "Unknown element");
            }
        }
        catch (RuntimeException rte) {
            new FrameworkLog(classLogInfo, 1941, rte).log();
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        Trace.trace(TRACE_MASKT, "-> parentalAction(" + event + ")");
        try {
            String command = event.getActionCommand();
            if (command == null) {
                command = "";
            }
            Trace.trace(TRACE_MASKF, "command=" + command);
            if (command.equals("")) {
                Trace.trace(TRACE_MASKF, "Unspecified command");
            } else if (command.endsWith("ParentalValidate")) {
                if (this.callHomeServer && this.m_bAllowPassThru) {
                    ((OutboundConnectivityBean)parent).setConnectivityEnabled();
                    if (this.passThruSystems.size() < 1) {
                        Integer minSystems = new Integer(1);
                        Integer numToAdd = new Integer(1 - this.passThruSystems.size());
                        String msgId = "MIN_PASSTHRU_SYSTEMS";
                        LocalizableText title = new LocalizableText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", msgId + ".TITLE");
                        Object[] subst = new Object[]{minSystems, numToAdd};
                        MessageText text = new MessageText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", msgId + ".MSG", subst);
                        Object[] msgInfo = new Object[]{title, text};
                        ((OutboundConnectivityBean)parent).setValidateErrorMsgInfo(msgInfo);
                    }
                }
            } else if (command.endsWith("ParentalCommit")) {
                try {
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource("PassThruSystemsBean");
                    request.setData("Source", "PassThruSystemsPanel");
                    request.setData("Command", "Commit");
                    request.setData("Bean", this);
                    this.postTaskletRequest(request);
                }
                catch (IllegalUserDataException iude) {}
            } else if (command.endsWith("ParentalUpdate")) {
                OutboundConnectivityBean outConnBean = (OutboundConnectivityBean)parent;
                this.callHomeServer = outConnBean.isCallHomeServer();
                this.updateUTMElements();
            } else {
                Trace.trace(TRACE_MASKF, "Unknown command");
            }
        }
        catch (RuntimeException rte) {
            new FrameworkLog(classLogInfo, 1941, rte).log();
        }
        Trace.trace(TRACE_MASKT, "<- parentalAction()");
    }

    public void update(Object newData) {
        Trace.trace(TRACE_MASKT, "-> update()");
        try {
            HashMap data = (HashMap)newData;
            String command = (String)data.get("Command");
            if (command == null) {
                command = "";
            }
            Trace.trace(TRACE_MASKF, "command=" + command);
            if (command.equals("")) {
                Trace.trace(TRACE_MASKF, "Unspecified command");
            } else if (command.equals("AddPassThruSystem")) {
                PassthruInfo newPassthruInfo = (PassthruInfo)data.get("PassThruInfo");
                if (newPassthruInfo != null) {
                    Trace.trace(TRACE_MASKF, "newSystem=" + newPassthruInfo);
                    this.passThruSystems.add(newPassthruInfo);
                    this.updateDataBeanInfo(false);
                    this.setPassThruSystemsTableSelection(new int[]{this.passThruSystems.size() - 1});
                }
            } else if (command.equals("UpdatePassThruSystem")) {
                PassthruInfo newPassthruInfo = (PassthruInfo)data.get("PassThruInfo");
                if (newPassthruInfo != null) {
                    Trace.trace(TRACE_MASKF, "updatedSystem=" + newPassthruInfo);
                    int[] selections = this.getPassThruSystemsTableSelection();
                    if (selections.length >= 1) {
                        int selected = selections[0];
                        this.passThruSystems.set(selected, newPassthruInfo);
                    }
                    this.updateDataBeanInfo(false);
                    this.updateUTMElements();
                }
            } else {
                Trace.trace(TRACE_MASKF, "Unknown command");
            }
        }
        catch (RuntimeException rte) {
            new FrameworkLog(classLogInfo, 1941, rte).log();
        }
        Trace.trace(TRACE_MASKT, "<- update()");
    }

    private void updateDataBeanInfo(boolean initialUpdate) {
        Trace.trace(TRACE_MASKT, "-> updateDataBeanInfo(" + initialUpdate + ")");
        int numOfPassthruSys = this.passThruSystems.size();
        Trace.trace(TRACE_MASKF, "numOfPassthruSys=" + numOfPassthruSys);
        this.m_idPassThruSystemsTable = new ItemDescriptor[numOfPassthruSys][2];
        for (int i = 0; i < numOfPassthruSys; ++i) {
            PassthruInfo systemInfo = (PassthruInfo)this.passThruSystems.get(i);
            String ipAddress = systemInfo.getIpAddress();
            this.m_idPassThruSystemsTable[i][0] = new ItemDescriptor(null, ipAddress);
            String comment = systemInfo.getDescription();
            this.m_idPassThruSystemsTable[i][1] = new ItemDescriptor(null, comment);
        }
        if (initialUpdate && this.passThruSystems.size() >= 1) {
            this.m_iPassThruSystemsTableSelection = new int[]{0};
        }
        int numOfCallHomeServers = this.callHomeServers.size();
        Trace.trace(TRACE_MASKF, "numOfCallHomeServers=" + numOfCallHomeServers);
        this.m_idDiscoveredServersTable = new ItemDescriptor[numOfCallHomeServers][2];
        for (int i = 0; i < numOfCallHomeServers; ++i) {
            PassthruInfo serverInfo = (PassthruInfo)this.callHomeServers.get(i);
            String ipAddress = serverInfo.getIpAddress();
            this.m_idDiscoveredServersTable[i][0] = new ItemDescriptor(null, ipAddress);
            String comment = serverInfo.getDescription();
            this.m_idDiscoveredServersTable[i][1] = new ItemDescriptor(null, comment);
        }
        Trace.trace(TRACE_MASKT, "<- updateDataBeanInfo()");
    }

    private void updateUTMElements() {
        Trace.trace(TRACE_MASKT, "-> updateUTMElements()");
        if (this.userTaskManager != null) {
            String prefix = this.getMountPrefix();
            if (this.m_bAllowPassThru) {
                this.userTaskManager.setSelected(prefix + "AllowPassThruCheckbox", true);
                if (this.callHomeServer) {
                    this.userTaskManager.setEnabled(prefix + "AllowPassThruCheckbox", true);
                    this.userTaskManager.setEnabled(prefix + "PassThruSystemsGroup", true);
                    this.userTaskManager.setEnabled(prefix + "PassThruSystemsTable", true);
                    if (this.passThruSystems.size() < 5) {
                        this.userTaskManager.setEnabled(prefix + "AddButton", true);
                    } else {
                        this.userTaskManager.setEnabled(prefix + "AddButton", false);
                    }
                } else {
                    this.userTaskManager.setEnabled(prefix + "AllowPassThruCheckbox", false);
                    this.userTaskManager.setEnabled(prefix + "PassThruSystemsGroup", false);
                    this.userTaskManager.setEnabled(prefix + "PassThruSystemsTable", false);
                    this.userTaskManager.setEnabled(prefix + "AddButton", false);
                }
            } else {
                this.userTaskManager.setSelected(prefix + "AllowPassThruCheckbox", false);
                if (this.callHomeServer) {
                    this.userTaskManager.setEnabled(prefix + "AllowPassThruCheckbox", true);
                } else {
                    this.userTaskManager.setEnabled(prefix + "AllowPassThruCheckbox", false);
                }
                this.userTaskManager.setEnabled(prefix + "PassThruSystemsGroup", false);
                this.userTaskManager.setEnabled(prefix + "PassThruSystemsTable", false);
                this.userTaskManager.setEnabled(prefix + "AddButton", false);
            }
            if (this.m_iPassThruSystemsTableSelection.length >= 1 && this.m_bAllowPassThru && this.callHomeServer) {
                this.userTaskManager.setEnabled(prefix + "EditButton", true);
                this.userTaskManager.setEnabled(prefix + "RemoveButton", true);
                this.userTaskManager.setEnabled(prefix + "TestButton", true);
                this.userTaskManager.setEnabled(prefix + "UpButton", true);
                this.userTaskManager.setEnabled(prefix + "DownButton", true);
            } else {
                this.userTaskManager.setEnabled(prefix + "EditButton", false);
                this.userTaskManager.setEnabled(prefix + "RemoveButton", false);
                this.userTaskManager.setEnabled(prefix + "TestButton", false);
                this.userTaskManager.setEnabled(prefix + "UpButton", false);
                this.userTaskManager.setEnabled(prefix + "DownButton", false);
            }
            this.userTaskManager.refreshElement(prefix + "AllowPassThruCheckbox");
            this.userTaskManager.refreshElement(prefix + "PassThruSystemsGroup");
            this.userTaskManager.refreshElement(prefix + "PassThruSystemsTable");
            this.userTaskManager.refreshElement(prefix + "AddButton");
            this.userTaskManager.refreshElement(prefix + "EditButton");
            this.userTaskManager.refreshElement(prefix + "RemoveButton");
            this.userTaskManager.refreshElement(prefix + "TestButton");
            this.userTaskManager.refreshElement(prefix + "UpButton");
            this.userTaskManager.refreshElement(prefix + "DownButton");
            this.userTaskManager.refreshElement(prefix + "DiscoveredServersGroup");
            this.userTaskManager.refreshElement(prefix + "DiscoveredServersTable");
        }
        Trace.trace(TRACE_MASKT, "<- updateUTMElements()");
    }
}

